<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Controller\Controller;
use Cake\ORM\TableRegistry;
use Cake\Core\Configure;
use Cake\Cache\Cache;
use Cake\Http\Cookie\Cookie;

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link https://book.cakephp.org/4/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{
    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('FormProtection');`
     *
     * @return void
     */
    public function initialize(): void
    {
        parent::initialize();

        $this->loadComponent('RequestHandler');
        $this->loadComponent('Flash');
		$this->loadComponent('AdManager2023');

        /*
         * Enable the following component for recommended CakePHP form protection settings.
         * see https://book.cakephp.org/4/en/controllers/components/form-protection.html
         */
        //$this->loadComponent('FormProtection');
    }


	
	function _findPageId($slug='',$slugs=array()){
		if(empty($slug)){
			return false;
		}
		
		if(empty($slugs)){
			$use_exclusive_slugs = true;
			$slugs = $this->_all_page_urls(false);
		}
		
		//$page = array_search($slug,$slugs);
		$page = array_keys($slugs, $slug);
		
		if(count($page)>1){
			$temp = $this->Pages->find()->select(['id'])->where(['id IN'=>$page])->order(['external_link ASC'])->first();
			return $temp->id;
		}
		else if(count($page)==1){
			return $page[0];
		}
		
		if(empty($page)){
			$page = false;
		}
		
		if($page !== false){
			return $page;
		}
		
		$parts = explode('/', $slug);
		foreach($parts as $key=>$value){
			if($value === ''){
				unset($parts[$key]);
			}
		}
		$parts = array_values($parts);
		
		while(empty($page) && !empty($parts)){
			$page = array_keys($slugs,'/'.implode('/', $parts).'/');
			array_pop($parts);
		}
		
		if(count($page)>1){
			$temp = $this->Pages->find()->select(['id'])->where(['id IN'=>$page])->order(['external_link ASC'])->first();
			$page = $temp->id;
		}
		else if(count($page)==1){
			$page = $page[0];
		}
		else {
			$page = false;
		}
		
		if(empty($page) && !empty($use_exclusive_slugs)){
			return $this->_findPageId($slug,$this->_all_page_urls(true));
		}
		
		return $page;
	}

	
	function _all_page_urls($include_external=true){
		$slug = 'page_urls_map';
		if(!$include_external){
			$slug .= '_strict';
		}
		
		$map = Cache::read($slug,'longest');
		if($map === false){
			$pages = $this->Pages->find('threaded')->select(['id','sef_url','external_link','parent_id'])->where(['archived'=>0]);
			
			$map = array();
			foreach($pages as $page){
				$this->_append_page_url($map, $page, '', $include_external);
			}
			Cache::write($slug,$map,'longest');
		}
		
		return $map;
	}


	
	function _set_cookie(){
		$session = $this->request->getSession();
		$domain = '.'.$_SERVER['HTTP_HOST'];
		$user = $session->read('user');
		if(!empty($user)){
			$hash = hash('sha256',Configure::read('salt').$user->token);
			$data = array(
				'id' => $user->id,
				'key' => $hash,
				'login_date' => date('Y-m-d H:i:s')
			);

			if($user->group_id>=2){
				$cookie = new Cookie(
					'user',              // name
					'some_value',        // value
					new \DateTime('+2 days') // expires in 1 day
				);
			}
			else {
				$cookie = new Cookie(
					'user',              // name
					'some_value',        // value
					new \DateTime('+5 years') // expires in 1 day
				);
			}
			
			// Add the cookie to the response
			$this->setResponse(
				$this->getResponse()->withCookie($cookie)
			);
		}
	}

	
	function _delete_cookie(){
		$expiredCookie = new Cookie('user', '', new \DateTime('-1 day'));
		$this->setResponse(
			$this->getResponse()->withExpiredCookie($expiredCookie)
		);
	}
}
