<?php
namespace App\Controller;

use App\Controller\PagesController;
use Cake\ORM\TableRegistry;
use Cake\Event\EventInterface;
use Cake\Datasource\ConnectionManager;
use Cake\Core\Configure;
use Cake\ORM\Locator\LocatorAwareTrait;

use Google\AdsApi\AdManager\v202211\Dimension;
use Google\AdsApi\AdManager\v202211\DimensionAttribute;
use Google\AdsApi\AdManager\v202211\Column;

use Google\Ads\GoogleAds\V18\Enums\TargetingDimensionEnum\TargetingDimension;

class CronsController extends PagesController {
	var $page_id = 1;
	
	public function initialize(): void
	{
		parent::initialize();

		$this->loadComponent('AdManager2023');
	}
 

	public function beforeFilter(EventInterface $event): void {
        parent::beforeFilter($event);
		
		//$this->Security->config('unlockedActions',['addToCart','shipping','addCoupon']);
		
		//$this->Transactions = TableRegistry::get('Transactions');
		$this->Clients = TableRegistry::get('Clients');
		$this->AdReports = TableRegistry::get('AdReports');
		$this->AdZones = TableRegistry::get('AdZones');
		$this->AdOrders = TableRegistry::get('AdOrders');
		// $this->AdLineItems = TableRegistry::get('AdLineItems');
		$this->AdCreatives = TableRegistry::get('AdCreatives');
		$this->AdCreativesLineItems = TableRegistry::get('AdCreativesLineItems');
		// $this->AdCustomTargetingKeys = TableRegistry::get('AdCustomTargetingKeys');
		// $this->AdCustomTargetingValues = TableRegistry::get('AdCustomTargetingValues');
		$this->CronsResults = TableRegistry::get('CronsResults');
		// $this->HighriseCompanies = TableRegistry::get('HighriseCompanies');
		// $this->HighriseEmails = TableRegistry::get('HighriseEmails');
		
		//Configure::write('debug',2);
	}
	
	function monthlyAdReports(){
		Configure::write('debug',2);
		set_time_limit(0);
		ignore_user_abort(true);
		ini_set('memory_limit','2000M');
		
		//require_once '../vendor/googleads/dec-4-2021/vendor/autoload.php';
		require_once 'vendor/googleads/googleads-php-lib-jan-17-2023/vendor/autoload.php';
		// require_once '../vendor/googleads/google-ads-php/';
		// require 'vendor/autoload.php';
		// require_once 'vendor/googleads/googleads-php-lib-april-2025/vendor/autoload.php';
		
		$now = date('Y-m-01');
		//if(strpos($_SERVER['HTTP_USER_AGENT'],'CV:DT') !== false){
			//$now = date('Y-m-d');
		//}

		
		$today = $this->CronsResults
			->find()
			->where(['CronsResults.started >' => $now.' 00:00:00', 'CronsResults.key' => 'monthly_ad_reports'])
			->first();
		if(!empty($today)){
			// die('This cron has already been started.');
			echo 'This cron has already been started.'.'<br>';
		} else {

			// Controller action

			$conn = ConnectionManager::get('default');

			$query = 'INSERT INTO crons_results (`key`, `started`, `result`, `created`, `modified`) 
					VALUES (:key, :started, :result, :created, :modified)';

			$stmt = $conn->prepare($query);

			// Then bind the parameters
			$stmt->bindValue('key', 'monthly_ad_reports');
			$stmt->bindValue('started', date('Y-m-d H:i:s'));
			$stmt->bindValue('result', '');
			$stmt->bindValue('created', date('Y-m-d H:i:s'));
			$stmt->bindValue('modified', date('Y-m-d H:i:s'));
			$stmt->execute();

		}
		
		
		$orders_map = $this->AdOrders->find('list',['keyField'=>'ad_manager_order_id','valueField'=>'id'])->toArray();
		$creatives_map = $this->AdCreatives->find('list',['keyField'=>'ad_manager_creative_id','valueField'=>'id'])->toArray();
		$zones_map = $this->AdZones->find('list',['keyField'=>'ad_manager_ad_unit_id','valueField'=>'id'])->toArray();

		if(false && strpos($_SERVER['HTTP_USER_AGENT'],'CV:DT') !== false){
			$clients = $this->Clients->find()->where(['Clients.archived'=>0,'Clients.ad_manager_company_id IS NOT NULL','Clients.id' => 398]);
		}
		else {
			$clients = $this->Clients->find()->where(['Clients.archived'=>0,'Clients.ad_manager_company_id IS NOT NULL']);
		}
		
		foreach($clients as $client){
			$name = date('F Y',strtotime('-1 month'));
			//if(strpos($_SERVER['HTTP_USER_AGENT'],'CV:DT') !== false){
			//	$name = date('F Y');
			//}


			$existingReport = $this->AdReports->find()->where(['AdReports.client_id'=>$client->id,'AdReports.name'=>$name])->first();

			if(empty($existingReport)){
				$dimensions = [
					Dimension::AD_UNIT_ID,
					Dimension::CREATIVE_ID,
					Dimension::DATE,
					Dimension::CUSTOM_CRITERIA,
					Dimension::ORDER_ID,
				];
				$attributes = [];
				$columns = [
					Column::AD_SERVER_IMPRESSIONS,
					Column::AD_SERVER_CLICKS
				];
				$conditions = [
					'ADVERTISER_ID' => $client->ad_manager_company_id
				];
				
				$start = date('Y-m-01',strtotime('-1 month'));
				$end = date('Y-m-t 23:59:59',strtotime('-1 month'));

				$reportQuery = $this->AdManager2023->reportQuery($dimensions, $attributes, $columns, $start, $end, $conditions);
				error_log("SOAP Location: " . $location);
				// $reportJob = $this->AdManager2023->reportJob($reportQuery);
				// print_r($reportJob);
				exit();
				$csv = $this->AdManager2023->downloadReport($reportJob);
				if(!empty($csv)){
					$rows = $this->AdManager2023->parseReport($csv);
				}

				
/*
				if(strpos($_SERVER['HTTP_USER_AGENT'],'CV:DT') !== false){
					Configure::write('debug',2);

				}
*/
		
				if(!empty($rows)){
					$report_data = array(
						'name' => $name,
						'type' => 'monthly',
						'token' => $this->_generate_token(),
						'client_id' => $client->id,
						'start' => $start,
						'end' => $end
					);
					echo 'here';
					print_r($report_data);
// 					$report = $this->AdReports->newEntity($report_data);
// 					$this->AdReports->save($report);
					
// 					foreach($rows as $row){
// 						$custom_criteria = explode('=', $row['custom_criteria']);
						
// 						$dimension_data = [
// 							'report_id' => $report->id,
// 							'zone_id' => $zones_map[$row['ad_unit_id']],
// 							'creative_id' => $creatives_map[$row['creative_id']],
// 							'order_id' => $orders_map[$row['order_id']],
// 							'date' => $row['date'],
// 							'custom_criteria_key' => $custom_criteria[0],
// 							'custom_criteria_value' => $custom_criteria[1],
// 							'impressions' => $row['ad_server_impressions'],
// 							'clicks' => $row['ad_server_clicks']
							
// 						];
						
// 						debug($dimension_data);
						
						
// 						$dimension = $this->AdReports->Dimensions->newEntity($dimension_data);
// 						$this->AdReports->Dimensions->save($dimension);
// 					}
					
					die();
				}

			}
		}
		
		// $crons_result->finished = date('Y-m-d H:i:s');
		// $this->CronsResults->save($crons_result);

		die();
	}
	
	function testing(){
		Configure::write('debug',2);
		
		$this->_updateAdvertisers();
		
		die('why does this work');
	}
	
	function adManagerSync(){
		set_time_limit(0);
		ignore_user_abort(true);
		ini_set('memory_limit','1000M');
		//Configure::write('debug',2);
		
		$this->_updateAdvertisers();
		debug('Advertisers updated.');
		
		$this->_updateAdUnits();
		debug('Zones updated.');
		
		$this->_updateOrders();
		debug('Orders updated.');
		
		$this->_updateLineItems();
		debug('Line items updated.');
		
		$this->_updateCreatives();
		debug('Creatives updated.');
		
		$this->_updateCreativeAssociations();
		debug('Creative associations updated.');
		
		$this->_updateCustomTargeting();
		debug('Custom targeting updated.');
		
		die();
	}
	
	function _updateAdvertisers(){
		$advertisers = $this->AdManager2023->getAdvertisers();
		
		if(!empty($advertisers)){
			foreach($advertisers as $advertiser){
				$client = $this->Clients->find()->where(['Clients.ad_manager_company_id'=>$advertiser['id']])->first();
				if(!empty($client)){
					$client->name = $advertiser['name'];
				}
				else {
					$client = $this->Clients->newEntity([]);
					$client->ad_manager_company_id = $advertiser['id'];
					$client->name = $advertiser['name'];
				}
				$this->Clients->save($client);
			}
		}
		
		
		
		$advertisers = $this->AdManager2023->getAdNetworks();
		
		if(!empty($advertisers)){
			foreach($advertisers as $advertiser){
				$client = $this->Clients->find()->where(['Clients.ad_manager_company_id'=>$advertiser['id']])->first();
				if(!empty($client)){
					$client->name = $advertiser['name'];
				}
				else {
					$client = $this->Clients->newEntity([]);
					$client->ad_manager_company_id = $advertiser['id'];
					$client->name = $advertiser['name'];
				}
				$this->Clients->save($client);
			}
		}

	}
	
	function _updateAdUnits(){
		$ad_units = $this->AdManager2023->getAddUnits();

		if(!empty($ad_units)){
			foreach($ad_units as $ad_unit){
				$ad_zone = $this->AdZones->find()->where(['AdZones.ad_manager_ad_unit_id'=>$ad_unit['id']])->first();
				if(!empty($ad_zone)){
					$ad_zone->name = $ad_unit['name'];
				}
				else {
					$ad_zone = $this->AdZones->newEntity([]);
					$ad_zone->ad_manager_ad_unit_id = $ad_unit['id'];
					$ad_zone->name = $ad_unit['name'];
				}
				$this->AdZones->save($ad_zone);
			}
		}
		
	}
	
	function _updateOrders(){
		$clients_map = $this->Clients->find('list',['keyField'=>'ad_manager_company_id','valueField'=>'id'])->toArray();
		
		$orders = $this->AdManager2023->getOrders();
		if(!empty($orders)){
			foreach($orders as $order){
				$ad_order = $this->AdOrders->find()->where(['AdOrders.ad_manager_order_id'=>$order['id']])->first();
				if(empty($ad_order)){
					$ad_order = $this->AdOrders->newEntity([]);
				}
	
				if(!empty($clients_map[$order['advertiser_id']])){
					$ad_order->ad_manager_order_id = $order['id'];
					$ad_order->name = $order['name'];
					$ad_order->start = $order['start'];
					$ad_order->end = $order['end'];
					$ad_order->archived = $order['archived'];
					$ad_order->status = $order['status'];
					$ad_order->client_id = $clients_map[$order['advertiser_id']];
	
					$this->AdOrders->save($ad_order);
				}
			}
		}
		
	}
	
	function _updateLineItems(){
		$orders_map = $this->AdOrders->find('list',['keyField'=>'ad_manager_order_id','valueField'=>'id'])->toArray();
		$existing_line_items = $this->AdLineItems->find('list',['keyField'=>'ad_manager_line_item_id','valueField'=>'id'])->toArray();
		
		$line_items = $this->AdManager2023->getLineItems();
		if(!empty($line_items)){
			foreach($line_items as $line_item){
				$ad_line_item = null;
				if(isset($existing_line_items[$line_item['id']])){
					$ad_line_item = $this->AdLineItems->find()->where(['AdLineItems.ad_manager_line_item_id'=>$line_item['id']])->first();
				}
				
				if(empty($ad_line_item)){
					$ad_line_item = $this->AdLineItems->newEntity([]);
				}
	
				if(!empty($orders_map[$line_item['order_id']])){
					$ad_line_item->ad_manager_line_item_id = $line_item['id'];
					$ad_line_item->name = $line_item['name'];
					$ad_line_item->start = $line_item['start'];
					$ad_line_item->end = $line_item['end'];
					$ad_line_item->archived = $line_item['archived'];
					$ad_line_item->order_id = $orders_map[$line_item['order_id']];
					$ad_line_item->type = $line_item['type'];
					$ad_line_item->status = $line_item['status'];
					
					$ad_line_item->primary_goal_type = $line_item['primary_goal_type'];
					$ad_line_item->primary_goal_unit_type = $line_item['primary_goal_unit_type'];
					$ad_line_item->primary_goal_units = $line_item['primary_goal_units'];
					
					$ad_line_item->impressions_delivered = $line_item['impressions_delivered'];
					$ad_line_item->clicks_delivered = $line_item['clicks_delivered'];
	
					$this->AdLineItems->save($ad_line_item);
				}
			}
		}

	}
	
	function _updateCreatives(){
		$clients_map = $this->Clients->find('list',['keyField'=>'ad_manager_company_id','valueField'=>'id'])->toArray();
		$existing_creatives = $this->AdCreatives->find('list',['keyField'=>'ad_manager_creative_id','valueField'=>'id'])->toArray();
		
		$creatives = $this->AdManager2023->getCreatives();
		if(!empty($creatives)){
			foreach($creatives as $creative){
				$ad_creative = null;
				if(isset($existing_creatives[$creative['id']])){
					$ad_creative = $this->AdCreatives->find()->where(['AdCreatives.ad_manager_creative_id'=>$creative['id']])->first();
				}
				
				if(empty($ad_creative)){
					$ad_creative = $this->AdCreatives->newEntity([]);
				}
	
				if(!empty($clients_map[$creative['advertiser_id']])){
					
					$ad_creative->ad_manager_creative_id = $creative['id'];
					$ad_creative->name = $creative['name'];
					$ad_creative->destination_url = $creative['destination_url'];
					$ad_creative->width = $creative['width'];
					$ad_creative->height = $creative['height'];
					$ad_creative->preview_url = $creative['preview_url'];
					$ad_creative->client_id = $clients_map[$creative['advertiser_id']];
					
					$this->AdCreatives->save($ad_creative);
				}
			}
		}

	}
	
	function _updateCreativeAssociations(){
		$creatives_map = $this->AdCreatives->find('list',['keyField'=>'ad_manager_creative_id','valueField'=>'id'])->toArray();
		$line_items_map = $this->AdLineItems->find('list',['keyField'=>'ad_manager_line_item_id','valueField'=>'id'])->toArray();
		
		
/*
		$map = [];
		$temp_map = $this->AdCreativesLineItems->find('list',['keyField'=>'creative_id','valueField'=>'line_item_id'])->toArray();
		foreach($temp_map as $key=>$value){
			$creative_id = $creatives_map[$key];
			$line_item_id = $line_items_map[$value];
			$map[$creative_id.'-'.$line_item_id] = 1;
		}
		unset($temp_map);
*/
		
		$associations = $this->AdManager2023->getCreativeAssociations();
		
		$conn = ConnectionManager::get('default');
		$stmt = $conn->execute('TRUNCATE TABLE `ad_creatives_line_items`;');
		
		foreach($associations as $assoc){
			if(!empty($creatives_map[$assoc['creative_id']]) && !empty($line_items_map[$assoc['line_item_id']])){
				$data = array(
					'creative_id' => $creatives_map[$assoc['creative_id']],
					'line_item_id' => $line_items_map[$assoc['line_item_id']],
					'start' => $assoc['start'],
					'end' => $assoc['end'],
					'start_date_type' => $assoc['start_date_type'],
					'status' => $assoc['status'],
					'destination_url' => $assoc['destination_url']
				);
				
				$association = $this->AdCreativesLineItems->newEntity($data);
				$this->AdCreativesLineItems->save($association);
			}
		}

	}
	
/*
	function updateCreativeAssociations(){
		//$this->_updateCreatives();
		//$this->_updateLineItems();
		$this->_updateCreativeAssociations();
		die();
	}
*/
	
	function _updateCustomTargetingKeys(){
		$existing_keys = $this->AdCustomTargetingKeys->find('list',['keyField'=>'ad_manager_custom_targeting_key_id','valueField'=>'id'])->toArray();
		
		$keys = $this->AdManager2023->getCustomTargetingKeys();
		if(!empty($keys)){
			foreach($keys as $key){
				$ad_key = null;
				if(isset($existing_keys[$key['id']])){
					$ad_key = $this->AdCustomTargetingKeys->find()->where(['AdCustomTargetingKeys.ad_manager_custom_targeting_key_id'=>$key['id']])->first();
				}
				
				if(empty($ad_key)){
					$ad_key = $this->AdCustomTargetingKeys->newEntity([]);
				}
				
				$ad_key->ad_manager_custom_targeting_key_id = $key['id'];
				$ad_key->name = $key['name'];
				$ad_key->display_name = $key['display_name'];
				$ad_key->type = $key['type'];
				$ad_key->status = $key['status'];
				
				$this->AdCustomTargetingKeys->save($ad_key);
			}
		}
	}
	
	function _updateCustomTargetingValues(){
		$keys_map = $this->AdCustomTargetingKeys->find('list',['keyField'=>'ad_manager_custom_targeting_key_id','valueField'=>'id'])->toArray();

		$existing_values = $this->AdCustomTargetingValues->find('list',['keyField'=>'ad_manager_custom_targeting_value_id','valueField'=>'id'])->toArray();
		
		$values = $this->AdManager2023->getCustomTargetingValues(false);

		if(!empty($values)){
			foreach($values as $value){
				$ad_value = null;
				if(isset($existing_values[$value['id']])){
					$ad_value = $this->AdCustomTargetingValues->find()->where(['AdCustomTargetingValues.ad_manager_custom_targeting_value_id'=>$value['id']])->first();
				}
				
				if(empty($ad_value)){
					$ad_value = $this->AdCustomTargetingValues->newEntity([]);
				}
	
				$ad_value->ad_manager_custom_targeting_value_id = $value['id'];
				$ad_value->name = $value['name'];
				$ad_value->display_name = $value['display_name'];
				$ad_value->match_type = $value['match_type'];
				$ad_value->status = $value['status'];
				$ad_value->custom_targeting_key_id = $keys_map[$value['key_id']];


				$this->AdCustomTargetingValues->save($ad_value);
			}
		}
	}
	
	function _updateCustomTargeting(){
		$this->_updateCustomTargetingKeys();
		$this->_updateCustomTargetingValues();
	}
	
	function highrise(){
		//Configure::write('debug',2);
		ignore_user_abort(true);
		set_time_limit(600);
		
		$this->_highrise_companies();
		//$this->_highrise_emails();
		die();
	}
	
	function _highrise_companies(){
		$token = '9fcf8b047efb8d5a717715e2445681f3';
		$url = 'https://dcm.highrisehq.com';

		$offset = 0;
		$count = 0;
		do {
			$result = $this->_highrise_request($token, $url, '/companies.xml?n='.$offset.'&since='.date('YmdHis',strtotime('-20 days')));
			$xml = simplexml_load_string($result);
			
			foreach($xml->company as $key=>$value){
				$data = array(
					'id' => (string)$value->id,
					'name' => trim((string)$value->name),
				);
				
				$company = $this->HighriseCompanies->newEntity($data);
				$this->HighriseCompanies->save($company);
				$count++;
			}
			
			$offset += 500;
		} while (!empty($xml->company) && $offset < 6000);
		
		echo $count;
	}
	
	function _highrise_emails(){
		$active_clients = $this->Clients->find('list',['keyField'=>'id','valueField'=>'highrise_company_id'])->where(['Clients.archived'=>0,'Clients.highrise_company_id IS NOT NULL'])->toArray();
		foreach($active_clients as $client_id => $company_id){
			$emails = $this->Highrise->getCompanyEmails($company_id,'xml');
			
			foreach($emails as $email){
				$data = array(
					'id' => (string)$email->id,
					'author_id' => (string)$email->{'author-id'},
					'highrise_company_id' => $company_id,
					'title' => (string)$email->title,
					'body' => (string)$email->body,
					'created' => str_replace('Z','',str_replace('T',' ',(string)$email->{'created-at'}))
				);
				
				$highrise_email = $this->HighriseEmails->newEntity($data);
				$this->HighriseEmails->save($highrise_email);
			}
			

		}
	}
	
/*
	function _highrise_companies(){
		$token = '9fcf8b047efb8d5a717715e2445681f3';
		$url = 'https://dcm.highrisehq.com';
		
		$offset = 0;
		$result = $this->_highrise_request($token, $url, '/companies.xml?n='.$offset);
		$xml = simplexml_load_string($result);
		
		die();
		//now we switch to "since"
		
		while(!empty($xml->company) && $offset < 30000){
			foreach($xml->company as $key=>$value){
				$data = array(
					'id' => (string)$value->id,
					'name' => trim((string)$value->name),
				);
				
				$company = $this->HighriseCompanies->newEntity($data);
				$this->HighriseCompanies->save($company);
								
				
			}
			
			$offset += 500;
			
			$result = $this->_highrise_request($token, $url, '/companies.xml?n='.$offset);
			$xml = simplexml_load_string($result);
			sleep(1);
		}
		
		die();

	}
*/
	
	function _highrise_request($token, $highrise_url, $url){
		$ch = curl_init($highrise_url.$url);
		//curl_setopt($ch, CURLOPT_HEADER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			'Content-type: application/xml',
			'User-Agent: Csek Creative (dylan@csekcreative.com)'
		));
		curl_setopt($ch, CURLOPT_USERPWD, $token.':X');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		//curl_setopt($ch, CURLOPT_POST,true);
		$result = curl_exec($ch);
		curl_close($ch);
		return $result;
	}
	
}