<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
	
class PagesController extends AppController {

	public function initialize(): void
	{
		parent::initialize();

		// Load the Users model
		$this->loadModel('AdReports');
		$this->loadModel('Users');
	}
	
	function index(){
		exit('Hello');
	}

	

    public function view(){
		
        $user = $this->request->getSession()->read('user');
        if(empty($user)){
            $this->redirect('/users/login/');
        }
		
		$conditions = [
			//'AdReports.created >=' => date('Y-m-01 00:00:00')
			'Clients.archived' => 0
		];
		
		if(!empty($this->request->params['named']['salesperson'])){
			$client_ids = $this->ClientsUsers
				->find('list',['keyField'=>'client_id','valueField'=>'client_id'])
				->where([
					'ClientsUsers.user_id' => $this->request->params['named']['salesperson'],
					'ClientsUsers.relationship' => 'salesperson'
				])
				->toArray()
			;
			$client_ids = array_values($client_ids);
			if(!empty($client_ids)){
				$conditions['AdReports.client_id IN'] = $client_ids;
			}
		}
		
		$this->paginate['AdReports'] = [
			'order' => ['AdReports.created' => 'DESC', 'AdReports.name'=>'ASC'],
			'contain' => ['Clients'=>['Users']],
			'conditions' => $conditions,
			'limit'=>40,
			'maxLimit' => 100
		];
		
		$reports = $this->paginate('AdReports');
		
		foreach($reports as $report){
			$salesperson = [];
			foreach($report->client->user as $user){
				if($user->_joinData->relationship == 'salesperson'){
					$salesperson = $user;
					break;
				}
			}
			$report->client->salesperson = $salesperson;
		}
		
		$this->set('reports', $reports);
		// echo json_encode($reports);

	}


    public function import(){
		echo 'IMPORT';
	}
}