<?php
namespace App\Controller;

use App\Controller\AppController;
use Cake\ORM\TableRegistry;
	
class UsersController extends AppController {

	
	function index(){
		exit('Hello');
	}

	function login() {
		
		if (!empty($this->request->getData('email'))) {
			
			$user = $this->Users->find()->where([
				'email'=>$this->request->getData('email'),
				'is_active' => 1
			])->first();

			if(!empty($user) && password_verify($this->request->getData('password'), $user->password)){
				
				$session = $this->request->getSession();
				$session->write('user',$user);
				$session->write('user_compat',$user->toArray());
				
				
				
				$this->_set_cookie();
				
				$redirect = $session->read('login.redirect');
				if(!empty($redirect)){
					$session->delete('login.redirect');
					$this->redirect($redirect);
				}
				
				//if($user->group_id>=2){
				//	$this->redirect('/simple/pages/');
				//}
				//else {
					$this->redirect('/');
				//}
			} else {
				$this->Flash->error('Your username or password were incorrect.','danger',3000);
			}
		}
	}


	
	function logout(){
		$this->getRequest()->getSession()->destroy();
		$this->_delete_cookie();
		$this->redirect('/users/login/');
	}
}