<?php
namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Cache\Cache;

class AdCreativesTable extends Table
{
	public function initialize(array $config) : void
    {
	    $this->addBehavior('Timestamp');
	    
	    $this->belongsTo('Clients');
	    
	    $this->belongsToMany('AdLineItems', [
            'through' => 'AdCreativesLineItems',
            'foreignKey'=>'creative_id',
            'targetForeignKey' => 'line_item_id',
            'propertyName' => 'line_items'
        ]);
	    
    }
    
    
}