<?php
namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Cache\Cache;

class AdLineItemsTable extends Table
{
	public function initialize(array $config) : void
    {
	    $this->addBehavior('Timestamp');
	    
	    $this->belongsToMany('AdCreatives', [
            'through' => 'AdCreativesLineItems',
            'foreignKey'=>'line_item_id',
            'targetForeignKey' => 'creative_id',
            'propertyName' => 'creatives'
        ]);
        
        $this->belongsTo('AdOrders', [
            'className' => 'AdOrders',
            'foreignKey' => 'order_id',
            'propertyName' => 'order'
        ]);
        
    }
    
    
}