<?php
namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Cache\Cache;

class AdOrdersTable extends Table
{
	public function initialize(array $config) : void
    {
	    $this->addBehavior('Timestamp');
	    
	    $this->hasMany('AdLineItems', [
			'className' => 'AdLineItems',
			'foreignKey' => 'order_id',
			'propertyName' => 'line_items',
			'sort' => ['AdLineItems.archived' => 'ASC','AdLineItems.start' => 'DESC']
		]);
		
		$this->belongsTo('Clients', [
            'className' => 'Clients',
            'foreignKey' => 'client_id',
            'propertyName' => 'client'
        ]);
	    
    }
    
    
}