<?php
namespace App\Model\Table;

use Cake\ORM\Table;

class ClientsTable extends Table
{
	public function initialize(array $config) : void
    {

        $this->setTable('clients'); // database table name
        $this->setPrimaryKey('id'); // your primary key field
		
	    $this->addBehavior('Timestamp');
	    
	    $this->hasMany('AdReports', [
			'className' => 'AdReports',
			'foreignKey' => 'client_id',
			'propertyName' => 'reports',
			'sort' => ['AdReports.created' => 'DESC']
		]);
		
		//  $this->hasMany('AdOrders', [
		// 	'className' => 'AdOrders',
		// 	'foreignKey' => 'client_id',
		// 	'propertyName' => 'orders',
		// 	'sort' => ['AdOrders.start' => 'DESC']
		// ]);
		
		$this->belongsToMany('Users', [
            'through' => 'ClientsUsers',
            'foreignKey'=>'client_id',
            'targetForeignKey' => 'user_id',
            'propertyName' => 'user'
        ]);
        
        // $this->belongsTo('HighriseCompanies', [
        //     'className' => 'HighriseCompanies',
        //     'propertyName' => 'highrise_company'
        // ]);
	    
    }
    
    
}