<?php

namespace App\Model\Table;

use Cake\ORM\Table;

class UsersTable extends Table {

	public function initialize(array $config) : void
    {
	    $this->addBehavior('Timestamp');
	    
        $this->belongsTo('UsersGroups', [
            'className' => 'UsersGroups',
            'foreignKey' => 'group_id',
            'propertyName' => 'group'
        ]);
        
        $this->hasMany('Addresses', [
            'className' => 'Addresses',
            'propertyName' => 'address',
            'foreignKey' => 'user_id',
            'dependent' => true
        ]);
        
        $this->hasMany('Orders', [
            'className' => 'Orders',
            'propertyName' => 'order',
            'foreignKey' => 'user_id',
            'dependent' => true
        ]);
    }

}
?>