<?php
use Cake\Utility\Inflector;
?>

<section class="content reports">
	<div class="box box-primary">
		<div class="box-header">
			<h3 class="box-title">Latest Reports</h3>
		</div>
		<div class="box-body">
			
			<?php
			if(!empty($reports)){
				echo '<div class="table-responsive">';
					echo '<table class="table table-bordered">';
						echo '<thead>';
							echo '<tr class="active">';
								echo '<td>Name</td>';
								echo '<td>Client</td>';
								echo '<td>Type</td>';
								echo '<td>Start</td>';
								echo '<td>End</td>';
								echo '<td>Salesperson</td>';
							echo '</tr>';
						echo '</thead>';
						echo '<tbody>';
							foreach($reports as $report){
								echo '<tr>';
									echo '<th>';
										echo '<a href="https://dashboard.nowmediainc.com/reports/ad_report/'.$report->token.'/" target="_blank">';
											echo $report->name;
										echo '</a>';
									echo '</th>';
									echo '<td>';
										echo '<div>'.$report->client->name.'</div>';
									echo '</td>';
									echo '<td>'.Inflector::humanize($report->type).'</td>';
									echo '<td>';
										echo date('M j, Y',strtotime($report->start));
									echo '</td>';
									echo '<td>';
										echo date('M j, Y',strtotime($report->end));
									echo '</td>';
									echo '<td>';
										if(!empty($report->client->salesperson)){
											echo $report->client->salesperson->first_name.' '.$report->client->salesperson->last_name;
										}
									echo '</td>';
								echo '</tr>';
							}
						echo '</tbody>';
					echo '</table>';
				echo '</div>';
			}
			?>
		</div>
	</div>
	
	<ul class="pagination">
    <?php
    // Instead of Paginator->options(), use query params
    $display = $this->request->getQuery('display');
    $queryParams = $this->request->getQueryParams();
    if (!empty($display)) {
        $queryParams['display'] = $display;
    }

    // set templates for li wrapping
    $this->Paginator->setTemplates([
        'number' => '<li><a href="{{url}}">{{text}}</a></li>',
        'current' => '<li class="active"><a href="{{url}}">{{text}}</a></li>',
        'prevActive' => '<li><a rel="prev" href="{{url}}">{{text}}</a></li>',
        'prevDisabled' => '<li class="disabled"><span>{{text}}</span></li>',
        'nextActive' => '<li><a rel="next" href="{{url}}">{{text}}</a></li>',
        'nextDisabled' => '<li class="disabled"><span>{{text}}</span></li>',
    ]);

    // now output
    echo $this->Paginator->prev('&laquo; Previous', ['escape' => false, 'url' => $queryParams]);
    echo $this->Paginator->numbers(['url' => $queryParams]);
    echo $this->Paginator->next('Next &raquo;', ['escape' => false, 'url' => $queryParams]);
    ?>
</ul>
	
</section>