<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$cakeDescription = 'CakePHP: the rapid development php framework';
?>
<!DOCTYPE html>
<html>
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?= $cakeDescription ?>:
        <?= $this->fetch('title') ?>
    </title>
    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->css(['normalize.min', 'milligram.min', 'fonts', 'cake', 'default.min']) ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>
</head>
<body>
    <?php $user = $this->request->getSession()->read('user'); ?>
    <header class="top-nav">
        <div class="row justify-content-between items-center">
            <div class="col-xs-9 col-sm-2 header-left">
                <a href="<?= $this->Url->build('/') ?>">
                    <img src="/img/NowMedia-Logo-01.png" alt="NowMedia Dashboard" title="NowMedia Dashboard" class="img-responsive logo">
                </a>
            </div>
            <div class="col-xs-2 col-sm-10">
                <div class="top-nav-links">
                    <?php $user ?>
                    <?
                    if(!empty($user)){
                    ?>
                        <a href="/users/logout/">Logout</a>
                    <? } ?>
                </div>
            </div>
        </div>
    </header>


    <main class="main">
        <div class="container">
            <?= $this->Flash->render() ?>
            <?= $this->fetch('content') ?>
        </div>
    </main>
    <footer>
    </footer>
</body>
</html>
