<?php

/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace Google\Ads\GoogleAds\Lib\V12;

use PHPUnit\Framework\TestCase;

/**
 * Unit tests for `GoogleAdsResponseMetadata`.
 *
 * @covers \Google\Ads\GoogleAds\Lib\V12\GoogleAdsResponseMetadata
 * @small
 */
class GoogleAdsResponseMetadataTest extends TestCase
{
    /** @var GoogleAdsResponseMetadata $googleAdsResponseMetadata */
    private $googleAdsResponseMetadata;

    /** @var array $metadata */
    private $metadata;

    /**
     * @see \PHPUnit\Framework\TestCase::setUp()
     */
    protected function setUp(): void
    {
        $this->metadata = ['request-id' => ['AbCdEf'], 'dummy-key' => ['value1', 'value2']];
        $this->googleAdsResponseMetadata = new GoogleAdsResponseMetadata($this->metadata);
    }

    public function testGetMetadata()
    {
        $this->assertEquals(
            $this->metadata,
            $this->googleAdsResponseMetadata->getMetadata()
        );
    }

    public function testGetRequestIdGrpc()
    {
        $this->assertEquals('AbCdEf', $this->googleAdsResponseMetadata->getRequestId());
    }

    public function testGetRequestIdRest()
    {
        $googleAdsResponseMetadata = new GoogleAdsResponseMetadata(['Request-Id' => ['AbCdEf']]);
        $this->assertEquals('AbCdEf', $googleAdsResponseMetadata->getRequestId());
    }

    public function testGetRequestIdNoMetadata()
    {
        $googleAdsResponseMetadata =
            new GoogleAdsResponseMetadata(['dummy-key' => ['value1', 'value2']]);
        $this->assertEquals(null, $googleAdsResponseMetadata->getRequestId());
    }
}
