var w=window,d=document,e=d.documentElement,g=d.getElementsByTagName('body')[0],windowWidth=w.innerWidth||e.clientWidth||g.clientWidth,windowHeight=w.innerHeight||e.clientHeight||g.clientHeight;

$(document).ready(function() {
	jQuery.cachedScript = function( url, options ){
		options = $.extend( options || {}, {
			dataType: "script",
			cache: true,
			url: url
		});
		return jQuery.ajax(options);
	};

	$("#mobile-menu").mmenu();

	$('body').on('change blur','.form-control.required',function(){
		if($(this).val() == ''){
			$(this).parent('.form-group').removeClass('has-success').removeClass('has-warning').addClass('has-error');
		}
		else {
			$(this).parent('.form-group').removeClass('has-error').removeClass('has-warning').addClass('has-success');
		}
	});

	$('body').on('submit','form',function(event){
		var passes = true;
		var e = null;
		$(this).find('input.required, select.required, textarea.required').each(function(key,value){
			if($(this).val() == ''){
				passes = false;
				e = this;
				return;
			}
		});
		$(this).find('.required input, .required select, .required textarea').each(function(key,value){
			if($(this).val() == ''){
				passes = false;
				e = this;
				return;
			}
		});

		if(!passes){
			$(e).focus();
			$('html, body').animate({
				scrollTop: $(e).offset().top-100
			}, 1000);
			event.preventDefault();
		}

	});

	//fix svg's on iOS and Safari
	$('body').on('click touchend','svg a',function(event){
		window.location.href = $(this).attr('href');
	});

	$('body').on('click','.faq a',function(){
	    $(this).toggleClass('active');
		$(this).next('.content').slideToggle(400);
	});

	//AJAX functionality if supported
	if(history.pushState && $('body.ajax_load_pages').length){
		//use this in the future
		var blacklist = ['jpg','jpeg','png','gif','pdf','zip'];
		$(window).load(function(){
			window.history.pushState({"html":$('#view-container').html(),"pageTitle":$('head>title').html()},"", window.location.href);
			$('body').on('click','a',function(event){
				var e = this;
				var href = $(e).attr('href');
				var target = $(e).attr('target');
				if(href > '' && href.substr(0, 1)=='/' && target != '_blank'){
					$.get(href,{},function(data){
						try {
							window.history.pushState({"html":data.html,"pageTitle":data.title},"", href);
							$('#view-container').html(data.html);
							if(data.javascript>''){
								$('<script>').attr('type', 'text/javascript').text(data.javascript).appendTo('head');
							}
							document.title = data.title;
							$.each(data.meta,function(key,value){
								if($('head meta[name="' + key + '"]').length){
									$('head meta[name="' + key + '"]').prop('content',value);
								}
								else {
									$('head').append('<meta name="' + key + '" content="' + value + '"/>');
								}
							});
						}
						catch(error){
							console.log(error);
							//window.location.href = href;
						}
					},'json');
					event.preventDefault();
				}
			});
			window.onpopstate = function(e){
				if(e.state){
					$('#view-container').html(e.state.html);
					document.title = e.state.pageTitle;
				}
			};
		});
	}
	
	$('body').on('click','.hideNoNameBox',function(event){
		var e = this;
		var target = $(e).attr('href');
		$(target).removeClass('visible');
		setTimeout(function(){
			$(target).remove();
		}, 2000);
		event.preventDefault();
	});
	
});

/* Same Height Plugin */
function match_height(){
	var match_groups = {};
	var match_group;
	var tmp_height = 0;
	$('.same').each(function(index){
	//$('.same:not(.samed)').each(function(index){
		match_group = $(this).attr('data-group');
		$(this).css('height','auto');
		tmp_height = $(this).outerHeight();
		if(!(match_group in match_groups))
			match_groups[match_group] = 0;
		if(tmp_height >= match_groups[match_group])
			match_groups[match_group] = tmp_height;

	});
	$.each(match_groups,function(key,value){
		$('.same[data-group="' + key + '"]').outerHeight(value).addClass('samed');
	});
}

function flash(message,className,seconds){
	if(typeof seconds == 'undefined'){
		seconds = 5;
	}
	if(typeof className == 'undefined'){
		className = 'success';
	}
	
	var html = '<div class="flash alert alert-' + className + '" style="visibility:hidden;">';
		html += '<div class="container">';
			html += message;
		html += '</div>';
	html += '</div>';
	$('body').append(html);
	
	var height = $('.flash').outerHeight()*-1;
	$('.flash').css({bottom:height,visibility:'visible'});
	setTimeout(function(){
		$('.flash').animate({bottom:0},500);
	},500);
	setTimeout(function(){
		$('.flash').animate({bottom:height},500,function(){ 
			$(this).remove()
		});
	}, ((seconds+1)*1000) + 500);
}

var noNameBoxIncrement = 0;

function noNameBox(title, content, buttons, opts){
	$('#noNameBox' + (noNameBoxIncrement-1)).remove();
	
	var options = {
		hideAfter: false
	};
	if(typeof opts != 'undefined'){
		for(var opt in opts){
			options[opt] = opts[opt];
		}
	}

	var html = '';
	html += '<div class="noNameBox" id="noNameBox' + noNameBoxIncrement + '">';
		html += '<a class="hideNoNameBox pull-right" href="#noNameBox' + noNameBoxIncrement + '"><i class="fa fa-times" aria-hidden="true"></i></a>';		
			html += '<h4 class="title">' + title + '</h4>';
			html += '<div class="product-wrap">';
			html += content;
			if(typeof buttons != 'undefined' && buttons.length){
				$.each(buttons,function(key,button){
					html += '<p><a class="btn btn-primary btn-block" href="' + button.link + '">' + button.text + '</a></p>';
				});
			}
		html += '</div>';
	html += '</div>';

	$('body').append(html);
	$('#noNameBox' + noNameBoxIncrement).addClass('visible');

	if(options.hideAfter != false){
		var target = '#noNameBox' + noNameBoxIncrement;
		setTimeout(function(){
			$(target).removeClass('visible');
			setTimeout(function(){
				$(target).remove();
			}, 2000);
		}, options.hideAfter);
	}

	noNameBoxIncrement++;
}

$(window).load(function(){
	if(windowWidth>=768){
		match_height();
	}
});
$(window).resize(function(){
	if(windowWidth>=768){
		match_height();
	}
});
