$(function(){
	if($('.fancybox').length){
		$('.fancybox').fancybox();
	}
	if($('.youtube').length){
		$('.youtube').keyup(function(){
			$(this).siblings('.youtube-preview').remove();
			var link = $(this).val().replace(new RegExp("watch\\?v=", "i"), 'embed/');
			if(link>''){
				$(this).after('<span class="input-group-addon youtube-preview"><a href="' + link + '" target="_blank">Preview Video</a></span>');
			}
		});
		$('body').on('click','.youtube-preview a', function(event){
			$.fancybox({'type':'iframe','href':$(this).attr('href')});
			event.preventDefault();
		});
		$('.youtube').trigger('keyup');
	}
	$('body').on('click','.click-popover',function(event){
		event.preventDefault();
	});
	
	if($('.character-count-input').length){
		$('.character-count-input').each(function(key,value){
			var length = $(this).val().length;
			$(this).parent().find('.character-count').html('length: ' + length);
		});
		$('body').on('change keyup','.character-count-input',function(event){
			var length = $(this).val().length;
			$(this).parent().find('.character-count').html('length: ' + length);
		});
	}

	function updateFieldValue(id,value,callback){
		if(id>''){
			$.ajax({
				url: '/simple/fields/update_field_value/' + id + '/',
				type: 'post',
				data: {'value':value},
				dataType: 'json',
				success: callback,
				beforeSend: function (xhr) {
					xhr.setRequestHeader('X-CSRF-Token', _csrfToken);
				},
			});
		}
	}
	
	function show_table(id){
		var e = $('#' + id);
		
		//remove all existing tables
		$('[data-target="' + id + '"]').remove();
		if($(e).val()==''){
			return false;
		}
		
		var info = JSON.parse($(e).val());
		if(typeof info != 'object'){
			return false;
		}
		console.log(info);
		
		var html = '';
		html += '<a href="#" data-target="' + id + '" class="label label-success pull-right addTableRow" data-add-to="top">Add Row</a>';
		html += '<br>';
		html += '<table class="table table-striped table-bordered fields-table" data-target="' + id + '">';
			html += '<thead>';
				html += '<tr>';
					$.each(info.columns,function(key,column){
						html += '<th>';
							html += column.value;
						html += '</th>';
					});
					html += '<th style="width:71px;"></th>';
				html += '</tr>';
			html += '</thead>';
			html += '<tbody>';
				$.each(info.rows, function(key,row){
					html += '<tr data-row="' + key + '">';
						$.each(row, function(columnKey,cell){
							html += '<td class="cell" data-column="' + columnKey + '">';
								html += cell.value;
							html += '</td>';
						});
						html += '<td>';
							html += '<a href="#" data-target="' + id + '" class="label label-danger removeTableRow">Remove</a>';
						html += '</td>';
					html += '</tr>';
				});
			html += '</tbody>';
		html += '</table>';
		html += '<a href="#" data-target="' + id + '" class="label label-success pull-right addTableRow" data-add-to="bottom">Add Row</a>';
		$(e).after(html);
	}
	
	function add_table_row(id,addTo){
		var info = JSON.parse($('#' + id).val());
		var row = [];
		$.each(info.columns,function(key,value){
			row.push({value:'Placeholder Text'});
		});
		
		if(addTo == 'bottom'){
			info.rows.push(row);
		}
		else if(addTo == 'top'){
			info.rows.unshift(row);
		}
		
		var json = JSON.stringify(info);
		$('#' + id).val(json);
		show_table(id);
	}
	
	function remove_table_row(id,row){
		var e = this;
		//array slice this shit

		var info = JSON.parse($('#' + id).val());
		delete info.rows[row];
		
		var newRows = [];
		$.each(info.rows,function(key,value){
			if(typeof value != 'undefined'){
				newRows.push(value);
			}
		});
		
		info.rows = newRows;
		var json = JSON.stringify(info);
		$('#' + id).val(json);
		show_table(id);
	}
	
	if($('.fields-table-json').length){
		$('.fields-table-json').each(function(key,value){
			var id = $(this).attr('id');
			show_table(id);
		});
	}
	
	$('body').on('click','.addTableRow',function(event){
		add_table_row($(this).data('target'),$(this).data('add-to'));
		event.preventDefault();
	});
	
	$('body').on('click','.removeTableRow',function(event){
		remove_table_row($(this).data('target'),$(this).parent().parent().data('row'));
		event.preventDefault();
	});
	
	$('body').on('click','.fields-table tbody td.cell',function(event){
		var e = this;
		var value = $(e).html();
		if(!$(e).find('input').length){
			var html = '<input type="text" class="form-control" value="' + value + '" />';
			$(e).html(html);
			$(e).find('input').focus();
		}
		
		event.preventDefault();
	});
	
	$('body').on('blur','.fields-table tbody td input',function(event){
		var e = this;
		var id = $(e).parents('.fields-table').data('target');
		var column = $(e).parent().data('column');
		var row = $(e).parent().parent('tr').data('row');

		var val = $(e).val();
		$(e).parent().html(val);
		
		var info = JSON.parse($('#' + id).val());
		info.rows[row][column].value = val;
		
		var json = JSON.stringify(info);
		$('#' + id).val(json);
	});
	
	//ajax request to update a single field
	$('body').on('click','.update-field-link',function(event){
		var e = this;
		var id = $(e).data('id');
		var value = $(e).data('value');
		updateFieldValue(id,value,function(data){
			if(data.status == 'success'){
				var label = $(e).data('label');
				if(label>''){
					$(e).parent().html(label);
				}
			}
		});
		event.preventDefault();
	});
	
	$('body').on('change','input[type=file].image-upload, .image-upload input[type=file]', function(event){
		var e = this;
		var filename = $(e).val();
		var allowed_extensions = ['jpg','jpeg','png','gif'];
		var passes = true;
		var message = false;
		
		if(filename>''){
			var ext = filename.substr(filename.lastIndexOf('.') + 1).toLowerCase();
			if(allowed_extensions.indexOf(ext)==-1){
				message = 'Please upload a photo in jpg, png, or gif format.';
				passes = false;
			}
		}
		
		if(passes == false){
			$(e).val('');
			alert(message);
		}
	});
	
	
	
	
	
	
	
	
	
	
	
	
	/* OLD CODE, NEED TO ELIMINATE THIS */
		// Rollovers for icons on objects
		$(".actionIcon").hover(function(){
			$(this).toggleClass("on");
		
		});
		// Clicks for icons on objects
		$(".pageVisible").click(function(){
			var pageId, idParts, visible, that = $(this);
			idParts = that.attr('id').split('_');
			
			if(idParts && idParts.length === 2) {
				
				pageId = idParts[1];
				visible = that.hasClass("on");
				if(visible){
					visible = 1;
				}
				else {
					visible = 0;
				}
			
			
				$.ajax({url:"/simple/pages/visible/"+pageId+"/"+visible,
					type:"GET",
					dataType:"json",			
					success: function(data,status,request){
						that.toggleClass("on");	
					},
					error:function(msg){
						alert('There was a problem changing the visibility of the page');
						
					}
						
				});
			}
		
		});
	/* END: OLD CODE, NEED TO ELIMINATE THIS */
});